/**
 * @file event-switches.h
 * Headers for the switch event provider for the Mode Control Entity
 * <p>
 * Copyright © 2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _EVENT_SWITCHES_H_
#define _EVENT_SWITCHES_H_

#include <glib.h>

/** Path to the SysFS interface for the keyboard slide status */
#define MCE_KBD_SLIDE_STATE_PATH			"/sys/devices/platform/gpio-switch/slide/state"
/** Value for the keyboard slide open state */
#define MCE_KBD_SLIDE_OPEN				"open"
/** Value for the keyboard slide closed state */
#define MCE_KBD_SLIDE_CLOSED				"closed"

/** Path to the SysFS interface for the headphone jack sense status */
#define MCE_HEADPHONE_STATE_PATH			"/sys/devices/platform/gpio-switch/headphone/state"
/** Value for the headphone connected state */
#define MCE_HEADPHONE_CONNECTED				"connected"
/** Value for the headphone disconnected state */
#define MCE_HEADPHONE_DISCONNECTED			"disconnected"

/** Path to the SysFS interface for the lock flicker-key status */
#define MCE_FLICKER_KEY_STATE_PATH			"/sys/devices/platform/gpio-switch/kb_lock/state"
/** Value for the lock flicker-key active state */
#define MCE_FLICKER_KEY_ACTIVE				"closed"
/** Value for the lock flicker-key inactive state */
#define MCE_FLICKER_KEY_INACTIVE			"open"

/** Path to the SysFS interface for the battery cover status */
#define MCE_BATTERY_COVER_STATE_PATH			"/sys/devices/platform/gpio-switch/bat_cover/cover_switch"
/** Value for the battery cover open state */
#define MCE_BATTERY_COVER_OPEN				"open"
/** Value for the battery cover closed state */
#define MCE_BATTERY_COVER_CLOSED			"closed"

/** Path to the SysFS interface for the lid cover status */
#define MCE_LID_COVER_STATE_PATH			"/sys/devices/platform/gpio-switch/prot_shell/cover_switch"
/** Value for the lid cover open state */
#define MCE_LID_COVER_OPEN				"open"
/** Value for the lid cover closed state */
#define MCE_LID_COVER_CLOSED				"closed"

/** Path to the SysFS interface for the USB cable status */
#define MCE_USB_CABLE_STATE_PATH			"/sys/devices/platform/gpio-switch/tahvo-usb/vbus_state"
/** Value for the USB cable connected state */
#define MCE_USB_CABLE_CONNECTED				"connected"
/** Value for the USB cable disconnected state */
#define MCE_USB_CABLE_DISCONNECTED			"disconnected"

/** Path to the SysFS interface for the MMC cover status */
#define MCE_MMC_COVER_STATE_PATH			"/sys/devices/platform/gpio-switch/mmci-omap.2/cover_switch"
/** Value for the MMC cover open state */
#define MCE_MMC_COVER_OPEN				"open"
/** Value for the MMC cover closed state */
#define MCE_MMC_COVER_CLOSED				"closed"


/* When MCE is made modular, this will be handled differently */
gboolean mce_switches_init(void);
void mce_switches_exit(void);

#endif /* _EVENT_SWITCHES_H_ */
