/**
 * @file event-keypress.h
 * Headers for the keypress event provider for the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _EVENT_KEYPRESS_H_
#define _EVENT_KEYPRESS_H_

#include <glib.h>

#include <linux/input.h>	/* KEY_POWER */

/** New input layer name of the N810 keyboard + keypad */
#define OMAP_KEYBOARD_N810		"Internal keyboard"
/** Old input layer name of the N810 keyboard + keypad */
#define OMAP_KEYBOARD_N810_OLD		"LM8323 keypad"
/** New input layer name of the N800 keypad */
#define OMAP_KEYPAD_N800		"Internal keypad"
/** Old input layer name of the N800 keypad */
#define OMAP_KEYPAD_N800_OLD		"TSC2301 keypad"
/** Input layer name of the 770 keypad */
#define OMAP_KEYPAD_770			"omap-keypad"
/** Input layer name for standard PC keyboards */
#define AT_KEYBOARD			"AT Translated Set 2 keyboard"

/** The input layer name of the Retu powerbutton */
#define RETU_POWERBUTTON		"retu-pwrbutton"
/**
 * XXX: Fallback! The input layer name of the powerbutton on a PC;
 * currently unused
 */
#define PC_POWERBUTTON			"Power Button (FF)"

/* KEY_POWER == [power] key on the Nokia 770, N800, and N810
 * KEY_F9 is used (for now) on PC's, but remapped internally
 */
#define POWER_BUTTON			KEY_POWER

/* When MCE is made modular, this will be handled differently */
gboolean mce_keypress_init(void);
void mce_keypress_exit(void);

#endif /* _EVENT_KEYPRESS_H_ */
