/**
 * @file devlock.h
 * Headers for the device lock component
 * of the Mode Control Entity
 * <p>
 * Copyright © 2004-2007 Nokia Corporation.  All rights reserved.
 * <p>
 * @author David Weinehall <david.weinehall@nokia.com>
 */
#ifndef _DEVICELOCK_H_
#define _DEVICELOCK_H_

#include <glib.h>

/** Name of DevLock configuration group */
#define MCE_CONF_DEVLOCK_GROUP			"DevLock"

/** Name of configuration key for device lock delay 0 */
#define MCE_CONF_DEVLOCK_DELAY_0		"DevLockDelay0"

/** Name of configuration key for device lock delay 1 */
#define MCE_CONF_DEVLOCK_DELAY_1		"DevLockDelay1"

/** Name of configuration key for device lock delay 2 */
#define MCE_CONF_DEVLOCK_DELAY_2		"DevLockDelay2"

/** Name of configuration key for device lock delay 3 */
#define MCE_CONF_DEVLOCK_DELAY_3		"DevLockDelay3"

/** Name of configuration key for device lock shutdown timeout */
#define MCE_CONF_DEVLOCK_SHUTDOWN_TIMEOUT	"DevLockShutdownTimeout"

/* Locks */
#ifndef MCE_GCONF_LOCK_PATH
/** Path to the GConf settings for the device lock */
#define MCE_GCONF_LOCK_PATH		"/system/osso/dsm/locks"
#endif /* MCE_GCONF_LOCK_PATH */

/** Default value for the device autolock enabled/disabled status */
#define DEFAULT_DEVICE_AUTOLOCK_ENABLED		FALSE	/* FALSE / TRUE */
/** Default value for the device autolock timeout, in minutes */
#define DEFAULT_DEVICE_AUTOLOCK_TIMEOUT		10	/* in minutes */
/** Default device lock unlock failure count */
#define DEFAULT_DEVICE_LOCK_FAILED		0	/* should be 0 */
/** Default device lock total unlock failure count */
#define DEFAULT_DEVICE_LOCK_TOTAL_FAILED	0	/* should be 0 */

/** Path to the GConf entry for the devicelock autolock setting */
#define MCE_GCONF_DEVICE_AUTOLOCK_ENABLED_PATH	MCE_GCONF_LOCK_PATH "/devicelock_autolock_enabled"
/** Path to the GConf entry for the devicelock autolock timeout */
#define MCE_GCONF_DEVICE_AUTOLOCK_TIMEOUT_PATH	MCE_GCONF_LOCK_PATH "/devicelock_autolock_timeout"
/** Path to the GConf entry for the failed attempts counter */
#define MCE_GCONF_DEVICE_LOCK_FAILED_PATH	MCE_GCONF_LOCK_PATH "/devicelock_failed"
/** Path to the GConf entry for the total failed attempts counter */
#define MCE_GCONF_DEVICE_LOCK_TOTAL_FAILED_PATH	MCE_GCONF_LOCK_PATH "/devicelock_total_failed"

/** Name of D-Bus callback to provide to Device Lock SystemUI */
#define MCE_DEVLOCK_CB_REQ		"devlock_callback"

/** Default delays used when an incorrect password is entered */
enum {
	DEFAULT_LOCK_DELAY_0 = 0,			/**< 0 seconds */
	DEFAULT_LOCK_DELAY_1 = 1,			/**< 1 second */
	DEFAULT_LOCK_DELAY_2 = 1,			/**< 1 second */
	DEFAULT_LOCK_DELAY_3 = 5,			/**< 5 seconds */
};

/** Default timeout before automatic shutdown from shutdown query */
#define DEFAULT_SHUTDOWN_TIMEOUT	30000		/**< 30 second delay */

/* When MCE is made modular, this will be handled differently */
gboolean mce_devlock_init(void);
void mce_devlock_exit(void);

#endif /* _DEVICELOCK_H_ */
