/**
 * Copyright (C) 2007 Nokia. All rights reserved.
 */

/** @file crawler-volume-monitor.h 
 * \brief Crawler volume monitor
 */

#ifndef CRAWLER_VOLUME_MONITOR_H
#define CRAWLER_VOLUME_MONITOR_H

#include <stdio.h>
#include <libgnomevfs/gnome-vfs-volume-monitor.h>
#include <libgnomevfs/gnome-vfs-volume.h>

#include "crawler-interface.h"

/**
 * Inits the volume monitor
 *
 * @param app_data common application data
 * @return TRUE on success, FALSE otherwise
 */
gboolean volume_monitor_init (AppData *app_data);

/**
 * Shuts down the volume monitor
 *
 * @param app_data common application data
 * @return TRUE on success, FALSE otherwise
 */
gboolean volume_monitor_shutdown (AppData *app_data);

#endif
