/**
 * Copyright (C) 2007 Nokia. All rights reserved.
 */

/** @file crawler_debug.h
 *  \brief Metadata crawler debug
 */ 

#ifndef CRAWLER_DEBUG_H
#define CRAWLER_DEBUG_H

#include <stdio.h>
#include <syslog.h>

#ifdef CRAWLER_DEBUG_STDERR
#define CRAWLER_DEBUG_ERR(fmt, arg...) \
        fprintf(stderr, "[%s:%d] ERROR: " fmt "\n", \
        __FILE__, __LINE__, ##arg)

#define CRAWLER_DEBUG_WARN(fmt, arg...) \
        fprintf(stderr, "[%s:%d] WARNING: " fmt "\n", \
        __FILE__, __LINE__, ##arg)

#define CRAWLER_DEBUG_INFO(fmt, arg...) \
        fprintf(stderr, "INFO: " fmt "\n", ##arg)

#define CRAWLER_DEBUG(fmt, arg...) \
        fprintf(stderr, "[%s:%d] DEBUG: " fmt "\n", __FILE__, __LINE__, ##arg)
#elif defined CRAWLER_DEBUG_SYSLOG
#define CRAWLER_DEBUG_ERR(fmt, arg...) \
        syslog(LOG_ERR | LOG_USER, "[%s:%d] ERROR: " fmt "\n", \
        __FILE__, __LINE__, ##arg)

#define CRAWLER_DEBUG_WARN(fmt, arg...) \
        syslog(LOG_WARNING | LOG_USER, "[%s:%d] WARNING: " fmt "\n", \
        __FILE__, __LINE__, ##arg)

#define CRAWLER_DEBUG_INFO(fmt, arg...) \
        syslog(LOG_INFO | LOG_USER, "INFO: " fmt "\n", ##arg)

#define CRAWLER_DEBUG(fmt, arg...) \
        syslog(LOG_DEBUG | LOG_USER, "[%s:%d] DEBUG: " fmt "\n", \
         __FILE__, __LINE__, ##arg)
#else
#define CRAWLER_DEBUG_ERR(fmt, arg...) \
        do {} while(0)

#define CRAWLER_DEBUG_WARN(fmt, arg...) \
        do {} while(0)

#define CRAWLER_DEBUG_INFO(fmt, arg...) \
        do {} while(0)

#define CRAWLER_DEBUG(fmt, arg...) \
        do {} while(0)
#endif



#endif /* CRAWLER_DEBUG_H */
