#!/bin/sh
# Script for running GNU toolchain for configuration

set -x

PKG_NAME="metalayer-crawler"

configure_files="`find $srcdir -name '{arch}' -prune -o -name configure.ac -print -o -name configure.in -print`"
for configure_ac in $configure_files; do
    if [ -f $configure_ac ]; then
	configure_file=$configure_ac
    fi
done

if grep "^A[CM]_PROG_LIBTOOL" $configure_file >/dev/null; then
    libtoolize --automake --copy
fi

aclocal-1.8

autoconf

if grep "^A[CM]_CONFIG_HEADER" $configure_file >/dev/null; then
    autoheader
	    # this prevents automake from thinking config.h.in is out of
	    # date, since autoheader doesn't touch the file if it doesn't
	    # change.
    test -f config.h.in && touch config.h.in
fi

automake-1.8 --add-missing --foreign --copy --force

if test x$NOCONFIGURE = x; then
    ./configure $@ && echo Now type \`make\' to compile $PKG_NAME || exit 1
else
    echo Skipping configure process.
fi
