/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_REQUEST_AUTH_DIALOG_H__
#define __OSSO_ABOOK_REQUEST_AUTH_DIALOG_H__

#include <gtk/gtkdialog.h>
#include <libebook/e-book.h>

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_REQUEST_AUTH_DIALOG \
                (osso_abook_request_auth_dialog_get_type ())
#define OSSO_ABOOK_REQUEST_AUTH_DIALOG(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_REQUEST_AUTH_DIALOG, \
                 OssoABookRequestAuthDialog))
#define OSSO_ABOOK_REQUEST_AUTH_DIALOG_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_REQUEST_AUTH_DIALOG, \
                 OssoABookRequestAuthDialogClass))
#define OSSO_ABOOK_IS_REQUEST_AUTH_DIALOG(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_REQUEST_AUTH_DIALOG))
#define OSSO_ABOOK_IS_REQUEST_AUTH_DIALOG_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_REQUEST_AUTH_DIALOG))
#define OSSO_ABOOK_REQUEST_AUTH_DIALOG_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_REQUEST_AUTH_DIALOG, \
                 OssoABookRequestAuthDialogClass))

typedef struct _OssoABookRequestAuthDialogPrivate
                OssoABookRequestAuthDialogPrivate;

typedef struct {
	GtkDialog parent;

        OssoABookRequestAuthDialogPrivate *priv;
} OssoABookRequestAuthDialog;

typedef struct {
	GtkDialogClass parent_class;
} OssoABookRequestAuthDialogClass;

GType
osso_abook_request_auth_dialog_get_type (void) G_GNUC_CONST;

GtkWidget *
osso_abook_request_auth_dialog_new      (void);

void
osso_abook_request_auth_dialog_set_book_view
                                        (OssoABookRequestAuthDialog *dialog,
                                         EBookView                  *book_view);

EBookView *
osso_abook_request_auth_dialog_get_book_view
                                        (OssoABookRequestAuthDialog *dialog);

void
osso_abook_request_auth_dialog_set_contact
                                        (OssoABookRequestAuthDialog *dialog,
                                         EContact                   *contact);

EContact *
osso_abook_request_auth_dialog_get_contact
                                        (OssoABookRequestAuthDialog *dialog);

G_END_DECLS

#endif /* __OSSO_ABOOK_REQUEST_AUTH_DIALOG_H__ */
