/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_PRESENCE_H__
#define __OSSO_ABOOK_PRESENCE_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef enum {
        OSSO_ABOOK_PRESENCE_ONLINE  = 0,
        OSSO_ABOOK_PRESENCE_AWAY    = 1,
        OSSO_ABOOK_PRESENCE_OFFLINE = 2,
        OSSO_ABOOK_PRESENCE_UNKNOWN = 3
} OssoABookPresenceStatus;

#define OSSO_ABOOK_TYPE_PRESENCE_STATUS \
                (osso_abook_presence_status_get_type ())

GType osso_abook_presence_status_get_type (void) G_GNUC_CONST;

#define OSSO_ABOOK_TYPE_PRESENCE \
                (osso_abook_presence_get_type ())
#define OSSO_ABOOK_PRESENCE(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_PRESENCE, \
                 OssoABookPresence))
#define OSSO_ABOOK_PRESENCE_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_PRESENCE, \
                 OssoABookPresenceClass))
#define OSSO_ABOOK_IS_PRESENCE(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_PRESENCE))
#define OSSO_ABOOK_IS_PRESENCE_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_PRESENCE))
#define OSSO_ABOOK_PRESENCE_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_PRESENCE, \
                 OssoABookPresenceClass))

typedef struct {
	GObject parent;
} OssoABookPresence;

typedef struct {
	GObjectClass parent_class;

        OssoABookPresenceStatus (* get_status) (OssoABookPresence *presence);
} OssoABookPresenceClass;

GType
osso_abook_presence_get_type      (void) G_GNUC_CONST; 

OssoABookPresenceStatus
osso_abook_presence_get_status    (OssoABookPresence *presence);

const char *
osso_abook_presence_get_icon_name (OssoABookPresence *presence);

int
osso_abook_presence_compare       (OssoABookPresence *a,
                                   OssoABookPresence *b);

G_END_DECLS

#endif /* __OSSO_ABOOK_PRESENCE_H__ */
