/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_MANUAL_GROUP_MANAGER_H__
#define __OSSO_ABOOK_MANUAL_GROUP_MANAGER_H__

#include "osso-abook-contact-model.h"
#include "osso-abook-manual-group.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_MANUAL_GROUP_MANAGER \
                (osso_abook_manual_group_manager_get_type ())
#define OSSO_ABOOK_MANUAL_GROUP_MANAGER(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_MANUAL_GROUP_MANAGER, \
                 OssoABookManualGroupManager))
#define OSSO_ABOOK_MANUAL_GROUP_MANAGER_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_MANUAL_GROUP_MANAGER, \
                 OssoABookManualGroupManagerClass))
#define OSSO_ABOOK_IS_MANUAL_GROUP_MANAGER(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_MANUAL_GROUP_MANAGER))
#define OSSO_ABOOK_IS_MANUAL_GROUP_MANAGER_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_MANUAL_GROUP_MANAGER))
#define OSSO_ABOOK_MANUAL_GROUP_MANAGER_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_MANUAL_GROUP_MANAGER, \
                 OssoABookManualGroupManagerClass))

typedef struct _OssoABookManualGroupManagerPrivate 
                OssoABookManualGroupManagerPrivate;

typedef struct {
	GObject parent;

        OssoABookManualGroupManagerPrivate *priv;
} OssoABookManualGroupManager;

typedef struct {
	GObjectClass parent_class;

        void (* group_created) (OssoABookManualGroupManager *manager,
                                OssoABookManualGroup        *group);
        void (* group_deleted) (OssoABookManualGroupManager *manager,
                                OssoABookManualGroup        *group);
} OssoABookManualGroupManagerClass;

GType
osso_abook_manual_group_manager_get_type (void) G_GNUC_CONST;

OssoABookManualGroupManager *
osso_abook_manual_group_manager_get      (void) G_GNUC_CONST;

const GList *
osso_abook_manual_group_manager_get_groups
                                         (OssoABookManualGroupManager *manager);

OssoABookManualGroup *
osso_abook_manual_group_manager_get_group
                                         (OssoABookManualGroupManager *manager,
                                          const char                  *name);

void
osso_abook_manual_group_manager_create_group
                                         (OssoABookManualGroupManager *manager,
                                          const char                  *name);

void
osso_abook_manual_group_manager_delete_group
                                         (OssoABookManualGroupManager *manager,
                                          OssoABookManualGroup        *group,
                                          OssoABookContactModel       *model);

void
osso_abook_manual_group_manager_rename_group
                                         (OssoABookManualGroupManager *manager,
                                          OssoABookManualGroup        *group,
                                          const char                  *new_name,
                                          OssoABookContactModel       *model);

G_END_DECLS

#endif /* __OSSO_ABOOK_MANUAL_GROUP_MANAGER_H__ */
