/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_GROUP_H__
#define __OSSO_ABOOK_GROUP_H__

#include <glib-object.h>
#include <libebook/e-contact.h>
#include <gtk/gtkwidget.h>

#include "osso-abook-presence.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_GROUP \
                (osso_abook_group_get_type ())
#define OSSO_ABOOK_GROUP(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_GROUP, \
                 OssoABookGroup))
#define OSSO_ABOOK_GROUP_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_GROUP, \
                 OssoABookGroupClass))
#define OSSO_ABOOK_IS_GROUP(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_GROUP))
#define OSSO_ABOOK_IS_GROUP_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_GROUP))
#define OSSO_ABOOK_GROUP_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_GROUP, \
                 OssoABookGroupClass))

typedef struct {
	GObject parent;
} OssoABookGroup;

typedef struct {
	GObjectClass parent_class;

        /* signals */
        void (* visibility_changed) (OssoABookGroup    *group,
                                     gboolean           visible);
        
        void (* refilter_contact)   (OssoABookGroup    *group,
                                     EContact          *contact);

        void (* refilter_presence)  (OssoABookGroup    *group,
                                     OssoABookPresence *presence);

        /* vtable */
        const char * (* get_name)         (OssoABookGroup    *group);

        void         (* set_name)         (OssoABookGroup    *group,
                                           const char        *name);

        const char * (* get_icon_name)    (OssoABookGroup    *group);

        GtkWidget  * (* get_empty_widget) (OssoABookGroup    *group);
        
        gboolean     (* is_visible)       (OssoABookGroup    *group);
        
        gboolean     (* includes_contact) (OssoABookGroup    *group,
                                           EContact          *contact,
                                           OssoABookPresence *presence);
        
        int          (* get_sort_weight)  (OssoABookGroup    *group);
        gboolean     (* get_sensitive)    (OssoABookGroup    *group);
} OssoABookGroupClass;

GType
osso_abook_group_get_type               (void) G_GNUC_CONST;

const char *
osso_abook_group_get_name               (OssoABookGroup    *group);

const char *
osso_abook_group_get_display_name       (OssoABookGroup    *group);

const char *
osso_abook_group_get_icon_name          (OssoABookGroup    *group);

GtkWidget *
osso_abook_group_get_empty_widget       (OssoABookGroup    *group);

gboolean
osso_abook_group_is_visible             (OssoABookGroup    *group);

gboolean
osso_abook_group_includes_contact       (OssoABookGroup    *group,
                                         EContact          *contact,
                                         OssoABookPresence *presence);

void
osso_abook_group_emit_refilter_contact  (OssoABookGroup    *group,
                                         EContact          *contact);

void
osso_abook_group_emit_refilter_presence (OssoABookGroup    *group,
                                         OssoABookPresence *presence);

int
osso_abook_group_get_sort_weight        (OssoABookGroup    *group);
gboolean
osso_abook_group_get_sensitive          (OssoABookGroup    *group);

int
osso_abook_group_compare                (OssoABookGroup    *a,
                                         OssoABookGroup    *b);

G_END_DECLS

#endif /* __OSSO_ABOOK_GROUP_H__ */
