/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_CONTACT_H__
#define __OSSO_ABOOK_CONTACT_H__

#include <libebook/e-book.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <time.h>

#include "osso-abook-manual-group.h"
#include "osso-abook-account.h"

G_BEGIN_DECLS

void
osso_abook_contact_commit           (EContact                 *contact,
                                     gboolean                  new,
                                     EBook                    *book);

void
osso_abook_contact_delete           (EContact                 *contact,
                                     EBook                    *book);

GdkPixbuf *
osso_abook_contact_get_photo        (EContact                 *contact);

void
osso_abook_contact_set_photo        (EContact                 *contact,
                                     const char               *filename,
                                     EBook                    *book);

GList *
osso_abook_contact_get_accounts     (EContact                 *contact,
                                     OssoABookAccountTypeFlags flags);

GList *
osso_abook_contact_get_groups       (EContact                 *contact);

void
osso_abook_contact_add_group        (EContact                 *contact,
                                     OssoABookManualGroup     *group,
                                     EBook                    *book);

void
osso_abook_contact_remove_group     (EContact                 *contact,
                                     OssoABookManualGroup     *group,
                                     EBook                    *book);

void
osso_abook_contact_replace_group (EContact                    *contact,
                                  OssoABookManualGroup        *old_group,
                                  OssoABookManualGroup        *new_group,
                                  EBook                       *book);

time_t
osso_abook_contact_get_last_used    (EContact                 *contact);

void
osso_abook_contact_set_blocked      (EContact                 *contact,
                                     gboolean                  blocked,
                                     EBook                    *book);

gboolean
osso_abook_contact_get_blocked      (EContact                 *contact); 

gboolean
osso_abook_contact_get_deleted      (EContact                 *contact);

gboolean
osso_abook_contact_can_block        (EContact                 *contact,
                                     const char              **infoprint);

gboolean
osso_abook_contact_can_request_auth (EContact                 *contact,
                                     const char              **infoprint);

const char *
osso_abook_contact_get_name         (EContact                 *contact);

const char *
osso_abook_contact_get_display_name (EContact                 *contact);

void
osso_abook_contact_initiate_chat    (EContact                 *contact,
                                     EBook                    *book);

void
osso_abook_contact_initiate_call    (EContact                 *contact,
                                     EBook                    *book);

gboolean
osso_abook_contact_send_email       (EContact                 *contact,
                                     EBook                    *book);

void
osso_abook_contact_clean            (EContact                 *contact);

G_END_DECLS

#endif /* __OSSO_ABOOK_CONTACT_H__ */
