/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_CONTACT_STARTER_H__
#define __OSSO_ABOOK_CONTACT_STARTER_H__

#include <gtk/gtkdialog.h>
#include <libebook/e-book.h>

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_CONTACT_STARTER \
                (osso_abook_contact_starter_get_type ())
#define OSSO_ABOOK_CONTACT_STARTER(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_STARTER, \
                 OssoABookContactStarter))
#define OSSO_ABOOK_CONTACT_STARTER_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_STARTER, \
                 OssoABookContactStarterClass))
#define OSSO_ABOOK_IS_CONTACT_STARTER(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_STARTER))
#define OSSO_ABOOK_IS_CONTACT_STARTER_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_STARTER))
#define OSSO_ABOOK_CONTACT_STARTER_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_STARTER, \
                 OssoABookContactStarterClass))

typedef struct {
	GtkDialog parent;
} OssoABookContactStarter;

typedef struct {
	GtkDialogClass parent_class;
} OssoABookContactStarterClass;

GType
osso_abook_contact_starter_get_type      (void) G_GNUC_CONST;

GtkWidget *
osso_abook_contact_starter_new           (void);

void
osso_abook_contact_starter_set_book_view (OssoABookContactStarter *starter,
                                          EBookView               *book_view);

EBookView *
osso_abook_contact_starter_get_book_view (OssoABookContactStarter *starter);

void
osso_abook_contact_starter_set_contact   (OssoABookContactStarter *starter,
                                          EContact                *contact);

EContact *
osso_abook_contact_starter_get_contact   (OssoABookContactStarter *starter);

G_END_DECLS

#endif /* __OSSO_ABOOK_CONTACT_STARTER_H__ */
