/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_ONLINE_GROUP_H__
#define __OSSO_ABOOK_ONLINE_GROUP_H__

#include "osso-abook-group.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_ONLINE_GROUP \
                (osso_abook_online_group_get_type ())
#define OSSO_ABOOK_ONLINE_GROUP(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_ONLINE_GROUP, \
                 OssoABookOnlineGroup))
#define OSSO_ABOOK_ONLINE_GROUP_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_ONLINE_GROUP, \
                 OssoABookOnlineGroupClass))
#define OSSO_ABOOK_IS_ONLINE_GROUP(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_ONLINE_GROUP))
#define OSSO_ABOOK_IS_ONLINE_GROUP_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_ONLINE_GROUP))
#define OSSO_ABOOK_ONLINE_GROUP_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_ONLINE_GROUP, \
                 OssoABookOnlineGroupClass))

typedef struct {
	OssoABookGroup parent;
} OssoABookOnlineGroup;

typedef struct {
	OssoABookGroupClass parent_class;
} OssoABookOnlineGroupClass;

GType
osso_abook_online_group_get_type (void) G_GNUC_CONST;

OssoABookGroup *
osso_abook_online_group_get      (void) G_GNUC_CONST;

G_END_DECLS

#endif /* __OSSO_ABOOK_ONLINE_GROUP_H__ */
