/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_GROUP_VIEW_H__
#define __OSSO_ABOOK_GROUP_VIEW_H__

#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtktreeview.h>

#include "osso-abook-group-model.h"
#include "osso-abook-manual-group.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_GROUP_VIEW \
                (osso_abook_group_view_get_type ())
#define OSSO_ABOOK_GROUP_VIEW(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_VIEW, \
                 OssoABookGroupView))
#define OSSO_ABOOK_GROUP_VIEW_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_GROUP_VIEW, \
                 OssoABookGroupViewClass))
#define OSSO_ABOOK_IS_GROUP_VIEW(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_VIEW))
#define OSSO_ABOOK_IS_GROUP_VIEW_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_GROUP_VIEW))
#define OSSO_ABOOK_GROUP_VIEW_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_VIEW, \
                 OssoABookGroupViewClass))

typedef struct {
	GtkScrolledWindow parent;
} OssoABookGroupView;

typedef struct {
	GtkScrolledWindowClass parent_class;

        void (* group_activated)            (OssoABookGroupView   *view,
                                             OssoABookGroup       *group);
        
        void (* group_selected)             (OssoABookGroupView   *view,
                                             OssoABookGroup       *group);
        
        void (* contacts_dropped)           (OssoABookGroupView   *view,
                                             OssoABookManualGroup *dropped_into,
                                             GList                *contact_ids);
        void (* insensitive_group_selected) (OssoABookGroupView   *view,
                                             OssoABookGroup       *group);
} OssoABookGroupViewClass;

GType
osso_abook_group_view_get_type         (void) G_GNUC_CONST;

GtkWidget *
osso_abook_group_view_new              (OssoABookGroupModel *model);

OssoABookGroupModel *
osso_abook_group_view_get_model        (OssoABookGroupView  *view);

OssoABookGroup *
osso_abook_group_view_get_focus        (OssoABookGroupView  *view);

GtkTreeView *
osso_abook_group_view_get_tree_view    (OssoABookGroupView  *view);

void
osso_abook_group_view_enable_drag_dest (OssoABookGroupView  *view);

G_END_DECLS

#endif /* __OSSO_ABOOK_GROUP_VIEW_H__ */
