/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_GROUP_SELECTOR_H__
#define __OSSO_ABOOK_GROUP_SELECTOR_H__

#include "osso-abook-group-view.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_GROUP_SELECTOR \
                (osso_abook_group_selector_get_type ())
#define OSSO_ABOOK_GROUP_SELECTOR(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_SELECTOR, \
                 OssoABookGroupSelector))
#define OSSO_ABOOK_GROUP_SELECTOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_GROUP_SELECTOR, \
                 OssoABookGroupSelectorClass))
#define OSSO_ABOOK_IS_GROUP_SELECTOR(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_SELECTOR))
#define OSSO_ABOOK_IS_GROUP_SELECTOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_GROUP_SELECTOR))
#define OSSO_ABOOK_GROUP_SELECTOR_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_SELECTOR, \
                 OssoABookGroupSelectorClass))

typedef struct {
	OssoABookGroupView parent;
} OssoABookGroupSelector;

typedef struct {
	OssoABookGroupViewClass parent_class;

        void (* extended_selection_changed)
                                   (OssoABookGroupSelector *selector,
                                    guint                   n_selected_rows);
} OssoABookGroupSelectorClass;

GType
osso_abook_group_selector_get_type       (void) G_GNUC_CONST;

GtkWidget *
osso_abook_group_selector_new            (OssoABookGroupModel    *model);

GList *
osso_abook_group_selector_get_extended_selection
                                         (OssoABookGroupSelector *selector);

void
osso_abook_group_selector_select_all     (OssoABookGroupSelector *selector);

void
osso_abook_group_selector_deselect_all   (OssoABookGroupSelector *selector);

void
osso_abook_group_selector_select_group   (OssoABookGroupSelector *selector,
                                          OssoABookGroup         *group);

void
osso_abook_group_selector_deselect_group (OssoABookGroupSelector *selector,
                                          OssoABookGroup         *group);

G_END_DECLS

#endif /* __OSSO_ABOOK_GROUP_SELECTOR_H__ */
