/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_DIALOGS_H__
#define __OSSO_ABOOK_DIALOGS_H__

#include <gtk/gtkwindow.h>
#include <libebook/e-book-view.h>

#include <libosso-abook/osso-abook-manual-group.h>
#include <libosso-abook/osso-abook-contact-model.h>

G_BEGIN_DECLS

/* Contact dialogs */
gboolean
osso_abook_delete_contact_dialog_run (GtkWindow             *parent,
                                      EBookView             *book_view,
                                      EContact              *contact);

void
osso_abook_delete_contacts_dialog_run (GtkWindow            *parent,
				       EBookView            *book_view,
				       GList                *contacts);

void
osso_abook_block_contact_dialog_run  (GtkWindow             *parent,
                                      EBookView             *book_view,
                                      EContact              *contact);

/* Group dialogs */
void
osso_abook_new_group_dialog_run      (GtkWindow             *parent);

void
osso_abook_rename_group_dialog_run   (GtkWindow             *parent,
                                      OssoABookContactModel *model,
                                      OssoABookManualGroup  *group);

void
osso_abook_delete_group_dialog_run   (GtkWindow             *parent,
                                      OssoABookContactModel *model,
                                      OssoABookManualGroup  *group);

/* Others */
GList *
osso_abook_choose_email_dialog_run   (GtkWindow              *parent,
				      EContact               *contact);

void
osso_abook_add_contact_dialog_run    (GtkWindow              *parent,
                                      EBookView              *book_view);

G_END_DECLS

#endif /* __OSSO_ABOOK_DIALOGS_H__ */
