/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_CONTACT_VIEW_H__
#define __OSSO_ABOOK_CONTACT_VIEW_H__

#include "osso-abook-tree-view.h"
#include "osso-abook-contact-model.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_CONTACT_VIEW \
                (osso_abook_contact_view_get_type ())
#define OSSO_ABOOK_CONTACT_VIEW(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_VIEW, \
                 OssoABookContactView))
#define OSSO_ABOOK_CONTACT_VIEW_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_VIEW, \
                 OssoABookContactViewClass))
#define OSSO_ABOOK_IS_CONTACT_VIEW(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_VIEW))
#define OSSO_ABOOK_IS_CONTACT_VIEW_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_VIEW))
#define OSSO_ABOOK_CONTACT_VIEW_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_VIEW, \
                 OssoABookContactViewClass))

typedef struct {
	OssoABookTreeView parent;
} OssoABookContactView;

typedef struct {
	OssoABookTreeViewClass parent_class;

        void (* contact_activated) (OssoABookContactView *view,
                                    EContact             *contact);

        void (* selection_changed) (OssoABookContactView *view,
                                    guint                 n_selected_rows);
} OssoABookContactViewClass;

GType
osso_abook_contact_view_get_type           (void) G_GNUC_CONST;

GtkWidget *
osso_abook_contact_view_new                (OssoABookContactModel *model,
                                            OssoABookFilterModel  *filter_model);

GtkWidget *
osso_abook_contact_view_new_basic          (OssoABookContactModel *model);

GList *
osso_abook_contact_view_get_selection      (OssoABookContactView  *view);

EContact *
osso_abook_contact_view_get_focus          (OssoABookContactView  *view);

void
osso_abook_contact_view_enable_drag_source (OssoABookContactView  *view);

G_END_DECLS

#endif /* __OSSO_ABOOK_CONTACT_VIEW_H__ */
