/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_CONTACT_MODEL_H__
#define __OSSO_ABOOK_CONTACT_MODEL_H__

#include <libebook/e-book-view.h>

#include "osso-abook-tree-model.h"
#include "osso-abook-contact-presence.h"

G_BEGIN_DECLS

typedef enum {
        OSSO_ABOOK_CONTACT_MODEL_COL_CONTACT  = 0,
                                /* EContact *                  */ 
        OSSO_ABOOK_CONTACT_MODEL_COL_PRESENCE = 1 
                                /* OssoABookContactPresence *  */
} OssoABookContactModelColumn;

#define OSSO_ABOOK_TYPE_CONTACT_MODEL \
                (osso_abook_contact_model_get_type ())
#define OSSO_ABOOK_CONTACT_MODEL(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_MODEL, \
                 OssoABookContactModel))
#define OSSO_ABOOK_CONTACT_MODEL_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_MODEL, \
                 OssoABookContactModelClass))
#define OSSO_ABOOK_IS_CONTACT_MODEL(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_MODEL))
#define OSSO_ABOOK_IS_CONTACT_MODEL_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_MODEL))
#define OSSO_ABOOK_CONTACT_MODEL_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_MODEL, \
                 OssoABookContactModelClass))

typedef struct _OssoABookContactModelPrivate OssoABookContactModelPrivate;

typedef struct {
	OssoABookTreeModel parent;

        OssoABookContactModelPrivate *priv;
} OssoABookContactModel;

typedef struct {
	OssoABookTreeModelClass parent_class;
} OssoABookContactModelClass;

GType
osso_abook_contact_model_get_type    (void) G_GNUC_CONST;

OssoABookContactModel *
osso_abook_contact_model_new         (void);

gboolean
osso_abook_contact_model_get_iter    (OssoABookContactModel *model,
                                      const char            *contact_uid,
                                      GtkTreeIter           *iter);

G_END_DECLS

#endif /* __OSSO_ABOOK_CONTACT_MODEL_H__ */
