/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_ALPHA_BAR_H__
#define __OSSO_ABOOK_ALPHA_BAR_H__

#include <gtk/gtkuimanager.h>

#include "osso-abook-tree-view.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_ALPHA_BAR \
                (osso_abook_alpha_bar_get_type ())
#define OSSO_ABOOK_ALPHA_BAR(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_ALPHA_BAR, \
                 OssoABookAlphaBar))
#define OSSO_ABOOK_ALPHA_BAR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_ALPHA_BAR, \
                 OssoABookAlphaBarClass))
#define OSSO_ABOOK_IS_ALPHA_BAR(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_ALPHA_BAR))
#define OSSO_ABOOK_IS_ALPHA_BAR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_ALPHA_BAR))
#define OSSO_ABOOK_ALPHA_BAR_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_ALPHA_BAR, \
                 OssoABookAlphaBarClass))

typedef struct _OssoABookAlphaBarPrivate OssoABookAlphaBarPrivate;

typedef struct {
	GObject parent;

        OssoABookAlphaBarPrivate *priv;
} OssoABookAlphaBar;

typedef struct {
	GObjectClass parent_class;
} OssoABookAlphaBarClass;

GType
osso_abook_alpha_bar_get_type          (void) G_GNUC_CONST;

OssoABookAlphaBar *
osso_abook_alpha_bar_new               (OssoABookTreeView *view);

OssoABookTreeView *
osso_abook_alpha_bar_get_view          (OssoABookAlphaBar *bar);

GtkActionGroup *
osso_abook_alpha_bar_get_action_group  (OssoABookAlphaBar *bar);

void
osso_abook_alpha_bar_merge             (OssoABookAlphaBar *bar,
                                        GtkUIManager      *ui_manager,
                                        guint              merge_id,
                                        const char        *path,
                                        gboolean           add_separators);
                                     
GtkWidget *
osso_abook_alpha_bar_create_button_row (OssoABookAlphaBar *bar);

G_END_DECLS

#endif /* __OSSO_ABOOK_ALPHA_BAR_H__ */
