/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_ACCOUNT_H__
#define __OSSO_ABOOK_ACCOUNT_H__

#include <libgalago/galago.h>
#include <libebook/e-vcard.h>

G_BEGIN_DECLS

typedef enum {
        OSSO_ABOOK_ACCOUNT_TYPE_CHAT  = 1 << 0,
        OSSO_ABOOK_ACCOUNT_TYPE_VOIP  = 1 << 1,
        OSSO_ABOOK_ACCOUNT_TYPE_EMAIL = 1 << 2,

        OSSO_ABOOK_ACCOUNT_TYPE_ALL   = (OSSO_ABOOK_ACCOUNT_TYPE_CHAT |
                                         OSSO_ABOOK_ACCOUNT_TYPE_VOIP |
                                         OSSO_ABOOK_ACCOUNT_TYPE_EMAIL)
} OssoABookAccountTypeFlags; 

#define OSSO_ABOOK_TYPE_ACCOUNT \
                (osso_abook_account_get_type ())
#define OSSO_ABOOK_ACCOUNT(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT, \
                 OssoABookAccount))
#define OSSO_ABOOK_ACCOUNT_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT, \
                 OssoABookAccountClass))
#define OSSO_ABOOK_IS_ACCOUNT(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT))
#define OSSO_ABOOK_IS_ACCOUNT_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT))
#define OSSO_ABOOK_ACCOUNT_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT, \
                 OssoABookAccountClass))

typedef struct _OssoABookAccountPrivate OssoABookAccountPrivate;

typedef struct {
	GObject parent;

        OssoABookAccountPrivate *priv;
} OssoABookAccount;

typedef struct {
	GObjectClass parent_class;

        void (* galago_account_available)   (OssoABookAccount *account,
                                             GalagoAccount    *galago_account);
        void (* galago_account_unavailable) (OssoABookAccount *account);
} OssoABookAccountClass;

GType
osso_abook_account_get_type           (void) G_GNUC_CONST;

OssoABookAccount *
osso_abook_account_get                (const char       *vcard_field,
                                       const char       *bound,
                                       const char       *user_name);

OssoABookAccount *
osso_abook_account_get_from_vcard     (EVCardAttribute  *attr);

const char *
osso_abook_account_get_vcard_field    (OssoABookAccount *account);

const char *
osso_abook_account_get_bound          (OssoABookAccount *account);

const char *
osso_abook_account_get_username       (OssoABookAccount *account);

GalagoAccount *
osso_abook_account_get_galago_account (OssoABookAccount *account);

G_END_DECLS

#endif /* __OSSO_ABOOK_ACCOUNT_H__ */
