/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef __OSSO_ABOOK_ACCOUNT_MODEL_H__
#define __OSSO_ABOOK_ACCOUNT_MODEL_H__

#include "osso-abook-tree-model.h"
#include "osso-abook-account-presence.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_ACCOUNT_MODEL_TUPLE \
                (osso_abook_account_model_tuple_get_type ())

/**
 * OssoABookAccountModelTuple:
 * @contact: #EContact of the tuple.
 * @account: #OssoABookAccount of the tuple.
 * @ref_count: Reference count of the tuple struct.
 *
 * Links an #EContact to an #OssoABookAccount.
 */
typedef struct {
        EContact         *contact;
        OssoABookAccount *account;

        int               ref_count;
} OssoABookAccountModelTuple;

GType
osso_abook_account_model_tuple_get_type (void) G_GNUC_CONST;

OssoABookAccountModelTuple *
osso_abook_account_model_tuple_new      (EContact                   *contact,
                                         OssoABookAccount           *account);

OssoABookAccountModelTuple *
osso_abook_account_model_tuple_ref      (OssoABookAccountModelTuple *tuple);

void
osso_abook_account_model_tuple_unref    (OssoABookAccountModelTuple *tuple);

guint
osso_abook_account_model_tuple_hash     (OssoABookAccountModelTuple *tuple);

gboolean
osso_abook_account_model_tuple_equal    (OssoABookAccountModelTuple *a,
                                         OssoABookAccountModelTuple *b);

/**
 * OssoABookAccountModelColumn:
 * @OSSO_ABOOK_ACCOUNT_MODEL_COL_CONTACT: The contact column, containing an #EContact
 * @OSSO_ABOOK_ACCOUNT_MODEL_COL_PRESENCE: The presence column, containing an #OssoABookAccountPresence
 * @OSSO_ABOOK_ACCOUNT_MODEL_COL_TUPLE: The tuple column, containing an #OssoABookAccountModelTuple
 *
 * The columns in an #OssoABookAccountModel.
 */
typedef enum {
        OSSO_ABOOK_ACCOUNT_MODEL_COL_CONTACT  = 0,
           OSSO_ABOOK_ACCOUNT_MODEL_COL_PRESENCE = 1,
           OSSO_ABOOK_ACCOUNT_MODEL_COL_TUPLE    = 2
} OssoABookAccountModelColumn;

#define OSSO_ABOOK_TYPE_ACCOUNT_MODEL \
                (osso_abook_account_model_get_type ())
#define OSSO_ABOOK_ACCOUNT_MODEL(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_MODEL, \
                 OssoABookAccountModel))
#define OSSO_ABOOK_ACCOUNT_MODEL_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT_MODEL, \
                 OssoABookAccountModelClass))
#define OSSO_ABOOK_IS_ACCOUNT_MODEL(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_MODEL))
#define OSSO_ABOOK_IS_ACCOUNT_MODEL_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT_MODEL))
#define OSSO_ABOOK_ACCOUNT_MODEL_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_MODEL, \
                 OssoABookAccountModelClass))

typedef struct _OssoABookAccountModelPrivate OssoABookAccountModelPrivate;

typedef struct {
	OssoABookTreeModel parent;

        OssoABookAccountModelPrivate *priv;
} OssoABookAccountModel;

typedef struct {
	OssoABookTreeModelClass parent_class;
} OssoABookAccountModelClass;

GType
osso_abook_account_model_get_type  (void) G_GNUC_CONST;

OssoABookAccountModel *
osso_abook_account_model_new       (OssoABookAccountTypeFlags   flags);

OssoABookAccountTypeFlags
osso_abook_account_model_get_flags (OssoABookAccountModel      *model);

void
osso_abook_account_model_set_single_contact
                                   (OssoABookAccountModel      *model,
                                    EContact                   *contact);

EContact *
osso_abook_account_model_get_single_contact
                                   (OssoABookAccountModel      *model);

gboolean
osso_abook_account_model_get_iter  (OssoABookAccountModel      *model,
                                    OssoABookAccountModelTuple *tuple,
                                    GtkTreeIter                *iter);

G_END_DECLS

#endif /* __OSSO_ABOOK_ACCOUNT_MODEL_H__ */
