/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 */

#ifndef CHAT_VOIP_SERVICE_DIALOG_H_
#define CHAT_VOIP_SERVICE_DIALOG_H_

/************************************************************
 * System includes
 ************************************************************/

/* GTK and GLIB */
#include <gtk/gtk.h>
#include <glib.h>

/* RtcomAccount */
#include <rtcom-account.h>

/************************************************************
 * Own includes
 ************************************************************/

/************************************************************
 * Own defines
 ************************************************************/

G_BEGIN_DECLS

/* GObject type definition macros */
#define CHAT_VOIP_SERVICE_DIALOG_TYPE            (chat_voip_service_dialog_get_type())
#define CHAT_VOIP_SERVICE_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                        CHAT_VOIP_SERVICE_DIALOG_TYPE, ChatVoipServiceDialog))
#define CHAT_VOIP_SERVICE_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), \
                                        CHAT_VOIP_SERVICE_DIALOG_TYPE, \
                                        ChatVoipServiceDialogClass))
#define IS_CHAT_VOIP_SERVICE_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                        CHAT_VOIP_SERVICE_DIALOG_TYPE))
#define IS_CHAT_VOIP_SERVICE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), \
                                        CHAT_VOIP_SERVICE_DIALOG_TYPE))
#define CHAT_VOIP_SERVICE_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), \
                                        CHAT_VOIP_SERVICE_DIALOG_TYPE, \
                                        ChatVoipServiceDialogClass))

/*
 * The actual "class" definitions
 */
typedef struct _ChatVoipServiceDialog      ChatVoipServiceDialog;
typedef struct _ChatVoipServiceDialogClass ChatVoipServiceDialogClass;

struct _ChatVoipServiceDialog {
    GtkDialog      parent;
};

struct _ChatVoipServiceDialogClass {
    GtkDialogClass parent_class;
};

GType      chat_voip_service_dialog_get_type(void);

/************************************************************
 * Public functions
 ************************************************************/

/*
 * Public creation function
 */
GtkWidget *chat_voip_service_dialog_new(
    GtkWindow *parent
);

/*
 * Sets connections to be used
 */
void chat_voip_service_dialog_set_accounts(
    ChatVoipServiceDialog *dialog,
    GList *accounts
);

/*
 * Gets currently selected account
 */
RtcomAccount *chat_voip_service_dialog_get_account(
    ChatVoipServiceDialog *dialog
);

G_END_DECLS

#endif /* CHAT_VOIP_SERVICE_DIALOG_H_ */
