/*
 * This file is part of libosso-rtcom
 *
 * Copyright (C) 2006 Nokia. All rights reserved.
 *
 * Contact: naba.kumar@nokia.com
 */

#ifndef __RTCOM_MANAGER_H__
#define __RTCOM_MANAGER_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define RTCOM_TYPE_MANAGER rtcom_manager_get_type()

#define RTCOM_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  RTCOM_TYPE_MANAGER, RtcomManager))

#define RTCOM_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  RTCOM_TYPE_MANAGER, RtcomManagerClass))

#define RTCOM_IS_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  RTCOM_TYPE_MANAGER))

#define RTCOM_IS_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  RTCOM_TYPE_MANAGER))

#define RTCOM_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  RTCOM_TYPE_MANAGER, RtcomManagerClass))

typedef struct {
    GObject parent;
    gpointer priv;
} RtcomManager;

typedef struct {
    GObjectClass parent_class;
} RtcomManagerClass;

GType rtcom_manager_get_type (void);

RtcomManager *rtcom_manager_lookup (const gchar *unique_name);
void rtcom_manager_free (RtcomManager *id);
void rtcom_manager_clear_cache (void);

/* get all managers; returns a list of RtcomManager *s */
GList *rtcom_managers_list (void);
void rtcom_managers_free_list (GList *list);

const gchar *rtcom_manager_get_unique_name (RtcomManager *id);
const gchar *rtcom_manager_get_bus_name (RtcomManager *id);
const gchar *rtcom_manager_get_object_path (RtcomManager *id);

G_END_DECLS

#endif /* __RTCOM_MANAGER_H__ */
