/*
 * This file is part of libosso-rtcom
 *
 * Copyright (C) 2006 Nokia. All rights reserved.
 *
 * Contact: naba.kumar@nokia.com
 */

#ifndef __RTCOM_PROFILE_H__
#define __RTCOM_PROFILE_H__

#include <glib.h>
#include <glib-object.h>

#include "rtcom-protocol.h"

G_BEGIN_DECLS

typedef enum
{
    RTCOM_PROFILE_CAPABILITY_NONE = 0,
    RTCOM_PROFILE_CAPABILITY_CHAT_P2P = 1 << 0,
    RTCOM_PROFILE_CAPABILITY_CHAT_ROOM = 1 << 1,
    RTCOM_PROFILE_CAPABILITY_CHAT_ROOM_LIST = 1 << 2,
    RTCOM_PROFILE_CAPABILITY_VOICE_P2P = 1 << 3,
    RTCOM_PROFILE_CAPABILITY_CONTACT_SEARCH = 1 << 4,
    RTCOM_PROFILE_CAPABILITY_SPLIT_ACCOUNT = 1 << 5,
    RTCOM_PROFILE_CAPABILITY_REGISTRATION_UI = 1 << 6
} RtcomProfileCapabilityFlags;

typedef struct {
    GObject parent;
    gpointer priv;
} RtcomProfile;

#define RTCOM_TYPE_PROFILE rtcom_profile_get_type()

#define RTCOM_PROFILE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  RTCOM_TYPE_PROFILE, RtcomProfile))

#define RTCOM_PROFILE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  RTCOM_TYPE_PROFILE, RtcomProfilewClass))

#define RTCOM_IS_PROFILE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  RTCOM_TYPE_PROFILE))

#define RTCOM_IS_PROFILE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  RTCOM_TYPE_PROFILE))

#define RTCOM_PROFILE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  RTCOM_TYPE_PROFILE, RtcomProfilewClass))

typedef struct {
        GObjectClass parent_class;
} RtcomProfileClass;

GType rtcom_profile_get_type (void);

RtcomProfile* rtcom_profile_new (const gchar *unique_name);

/* to find one profile */
RtcomProfile *rtcom_profile_lookup (const gchar *unique_name);
RtcomProfile *rtcom_profile_lookup_default_for_vcard_field (const gchar *vcard_field);
void rtcom_profile_free (RtcomProfile *id);
void rtcom_profile_clear_cache (void);

/* to find many profiles */
GList *rtcom_profiles_list (void);
GList *rtcom_profiles_list_by_vcard_field (const gchar *vcard_field);
void rtcom_profiles_free_list (GList *list);

const gchar *rtcom_profile_get_unique_name (RtcomProfile *id);
const gchar *rtcom_profile_get_configuration_ui (RtcomProfile *id);
const gchar *rtcom_profile_get_display_name (RtcomProfile *id);
const gchar *rtcom_profile_get_icon_name (RtcomProfile *id);
const gchar *rtcom_profile_get_branding_icon_name (RtcomProfile *id);
const gchar *rtcom_profile_get_vcard_field (RtcomProfile *id);
const gchar *rtcom_profile_get_default_account_domain (RtcomProfile *id);
gboolean rtcom_profile_get_supports_invisible (RtcomProfile *id);
RtcomProtocol *rtcom_profile_get_protocol (RtcomProfile *id);

/* only use this protocol name instead of the real RtcomProfile if you do
 * not care about being able to discover the correct connection manager
 * and hence which options are valid when connecting a certain account.
 * without the manager name also, the protocol name is not sufficient
 * to look up an RtcomProfile. this is intentional. */
const gchar *rtcom_profile_get_protocol_name (RtcomProfile *id);

gboolean rtcom_profile_is_default_for_vcard_field (RtcomProfile *id);
RtcomProfileCapabilityFlags rtcom_profile_get_capabilities (RtcomProfile *id);
const gchar *rtcom_profile_get_default_setting (RtcomProfile *id, const gchar *setting);

G_END_DECLS

#endif /* __RTCOM_PROFILE_H__ */
