/*
 * This file is part of libosso-rtcom
 *
 * Copyright (C) 2006 Nokia. All rights reserved.
 *
 * Contact: naba.kumar@nokia.com
 */

#ifndef __RTCOM_CONFIGURATION_UI_INTERFACE_H__
#define __RTCOM_CONFIGURATION_UI_INTERFACE_H__

#include <glib.h>

G_BEGIN_DECLS

typedef enum
{
	RTCOM_CFG_PAGE_ADD_EXISTING = 0, /* page to add registred account */
	RTCOM_CFG_PAGE_REGISTER_NEW,     /* page to register new account  */
	RTCOM_CFG_PAGE_EDIT              /* page to edit account          */
} RtcomCfgPageType;

typedef void (*RtcomCfgPageOnSwitchCallback) (gboolean turn_page, gpointer user_data);

/*
 * Creats widget to create/add/edit an account in account wizard
 * Created widget is used as a page in wizard's notebook
 *
 * @profile_id:    profile unique name
 * @type:          page type
 * @parent:        wizard window
 * @next_button:   wizard next button
 * @prev_button:   wizard previous button
 * @finish_button: wizard finish button
 * @osso_context:  osso_context_t may be used to enable help
 *
 * wizard buttons provided to give to plugin ability to make them insensitive
 * E.g next_button can be used to prevent page switching while required 
 * entries are empty
 *
 */
GtkWidget* rtcom_cfg_page_create (
	const gchar *profile_id,
	RtcomCfgPageType type,
	GtkWindow *parent,
	GtkWidget *next_button,
        GtkWidget *prev_button,
	GtkWidget *finish_button,
	gpointer osso_context);

/*
 * Returns page type
 */
RtcomCfgPageType rtcom_cfg_page_get_type (void);

/**
 * This function is called when wizard is about to show or hide the page.
 * May be used to perform data validation.
 * Page will not be switched until the function pass TRUE in the callback.
 **/
void rtcom_cfg_page_onswitch (gboolean show, RtcomCfgPageOnSwitchCallback handler, gpointer user_data);

/**
 * Loads account data
 * @account_id: account id
 */
void rtcom_cfg_page_load (const gchar *account_id);

/**
 * Depending on page type, saves new account or updates existing one.
 * The function is called when wizard is closed by pressing finish button.
 */
void rtcom_cfg_page_save (void);

/**
 * Frees resources allocated for the page. Called when wizard is closed
 * by click on next or finish buttons.
 */
void rtcom_cfg_page_free (void);

G_END_DECLS

#endif
