/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_TREE_MODEL_H__
#define __OSSO_ABOOK_TREE_MODEL_H__

#include <gtk/gtkliststore.h>
#include <libebook/e-book-view.h>

#include "osso-abook-presence.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_TREE_MODEL \
                (osso_abook_tree_model_get_type ())
#define OSSO_ABOOK_TREE_MODEL(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_TREE_MODEL, \
                 OssoABookTreeModel))
#define OSSO_ABOOK_TREE_MODEL_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_TREE_MODEL, \
                 OssoABookTreeModelClass))
#define OSSO_ABOOK_IS_TREE_MODEL(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_TREE_MODEL))
#define OSSO_ABOOK_IS_TREE_MODEL_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_TREE_MODEL))
#define OSSO_ABOOK_TREE_MODEL_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_TREE_MODEL, \
                 OssoABookTreeModelClass))

typedef struct _OssoABookTreeModelPrivate OssoABookTreeModelPrivate;

typedef struct {
	GtkListStore parent;

        OssoABookTreeModelPrivate *priv;
} OssoABookTreeModel;

typedef struct {
	GtkListStoreClass parent_class;
        
        void (* done_loading)     (OssoABookTreeModel *model);

        /* vtable */
        void (* contact_added)    (OssoABookTreeModel *model,
                                   EContact           *contact);

        void (* contact_changed)  (OssoABookTreeModel *model,
                                   EContact           *contact);

        void (* contact_removed)  (OssoABookTreeModel *model,
                                   const char         *id);

        void (* clear)            (OssoABookTreeModel *model);

        void (* presence_changed) (OssoABookTreeModel *model,
                                   OssoABookPresence  *presence);
} OssoABookTreeModelClass;

GType
osso_abook_tree_model_get_type            (void) G_GNUC_CONST;

guint
osso_abook_tree_model_get_contact_column  (OssoABookTreeModel *model);

guint
osso_abook_tree_model_get_presence_column (OssoABookTreeModel *model);

void
osso_abook_tree_model_set_book_view       (OssoABookTreeModel *model,
                                           EBookView          *book_view);

EBookView *
osso_abook_tree_model_get_book_view       (OssoABookTreeModel *model);

gboolean
osso_abook_tree_model_is_done_loading     (OssoABookTreeModel *model);

void
osso_abook_tree_model_contact_changed     (OssoABookTreeModel *model,
                                           EContact           *contact);

void
osso_abook_tree_model_presence_changed    (OssoABookTreeModel *model,
                                           OssoABookPresence  *presence);

G_END_DECLS

#endif /* __OSSO_ABOOK_TREE_MODEL_H__ */
