/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_SERVICE_GROUP_H__
#define __OSSO_ABOOK_SERVICE_GROUP_H__

#include <libebook/e-book-view.h>
#include <libosso-rtcom/rtcom-account.h>

#include "osso-abook-group.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_SERVICE_GROUP \
                (osso_abook_service_group_get_type ())
#define OSSO_ABOOK_SERVICE_GROUP(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_SERVICE_GROUP, \
                 OssoABookServiceGroup))
#define OSSO_ABOOK_SERVICE_GROUP_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_SERVICE_GROUP, \
                 OssoABookServiceGroupClass))
#define OSSO_ABOOK_IS_SERVICE_GROUP(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_SERVICE_GROUP))
#define OSSO_ABOOK_IS_SERVICE_GROUP_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_SERVICE_GROUP))
#define OSSO_ABOOK_SERVICE_GROUP_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_SERVICE_GROUP, \
                 OssoABookServiceGroupClass))

typedef struct _OssoABookServiceGroupPrivate OssoABookServiceGroupPrivate;

typedef struct {
	OssoABookGroup parent;

        OssoABookServiceGroupPrivate *priv;
} OssoABookServiceGroup;

typedef struct {
	OssoABookGroupClass parent_class;
} OssoABookServiceGroupClass;

GType
osso_abook_service_group_get_type      (void) G_GNUC_CONST;

OssoABookGroup *
osso_abook_service_group_get           (RtcomAccount *account) G_GNUC_CONST;

G_END_DECLS

char *
osso_abook_rtcom_account_get_display_string (RtcomAccount * account);

#endif /* __OSSO_ABOOK_SERVICE_GROUP_H__ */
