/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_SELECT_DIALOG_H__
#define __OSSO_ABOOK_SELECT_DIALOG_H__

#include <gtk/gtkdialog.h>

#include "osso-abook-tree-view.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_SELECT_DIALOG \
                (osso_abook_select_dialog_get_type ())
#define OSSO_ABOOK_SELECT_DIALOG(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_SELECT_DIALOG, \
                 OssoABookSelectDialog))
#define OSSO_ABOOK_SELECT_DIALOG_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_SELECT_DIALOG, \
                 OssoABookSelectDialogClass))
#define OSSO_ABOOK_IS_SELECT_DIALOG(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_SELECT_DIALOG))
#define OSSO_ABOOK_IS_SELECT_DIALOG_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_SELECT_DIALOG))
#define OSSO_ABOOK_SELECT_DIALOG_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_SELECT_DIALOG, \
                 OssoABookSelectDialogClass))

typedef struct _OssoABookSelectDialogPrivate OssoABookSelectDialogPrivate;

typedef struct {
	GtkDialog parent;

        OssoABookSelectDialogPrivate *priv;
} OssoABookSelectDialog;

typedef struct {
	GtkDialogClass parent_class;

        gboolean (* ok_insensitive_press) (OssoABookSelectDialog *dialog);
} OssoABookSelectDialogClass;

GType
osso_abook_select_dialog_get_type      (void) G_GNUC_CONST;

GtkWidget *
osso_abook_select_dialog_new           (OssoABookTreeView     *tree_view);

GtkWidget *
osso_abook_select_dialog_new_no_alpha  (OssoABookTreeView     *tree_view);

OssoABookTreeView *
osso_abook_select_dialog_get_tree_view (OssoABookSelectDialog *dialog);

G_END_DECLS

#endif /* __OSSO_ABOOK_SELECT_DIALOG_H__ */
