/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_CONTACT_GROUP_EDITOR_H__
#define __OSSO_ABOOK_CONTACT_GROUP_EDITOR_H__

#include <gtk/gtkdialog.h>

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_CONTACT_GROUP_EDITOR \
                (osso_abook_contact_group_editor_get_type())
#define OSSO_ABOOK_CONTACT_GROUP_EDITOR(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_GROUP_EDITOR, \
                 OssoABookContactGroupEditor))
#define OSSO_ABOOK_CONTACT_GROUP_EDITOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_GROUP_EDITOR, \
                 OssoABookContactGroupEditorwClass))
#define OSSO_ABOOK_IS_CONTACT_GROUP_EDITOR(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                OSSO_ABOOK_TYPE_CONTACT_GROUP_EDITOR))
#define OSSO_ABOOK_IS_CONTACT_GROUP_EDITOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_GROUP_EDITOR))
#define OSSO_ABOOK_CONTACT_GROUP_EDITOR_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_GROUP_EDITOR, \
                 OssoABookContactGroupEditorwClass))

typedef struct {
        GtkDialog parent;
} OssoABookContactGroupEditor;

typedef struct {
        GtkDialogClass parent_class;
} OssoABookContactGroupEditorClass;

GType
osso_abook_contact_group_editor_get_type
                                    (void) G_GNUC_CONST;

GtkWidget *
osso_abook_contact_group_editor_new (void);

void
osso_abook_contact_group_editor_set_book_view
                                    (OssoABookContactGroupEditor *editor,
                                     EBookView                   *book_view);

EBookView *
osso_abook_contact_group_editor_get_book_view
                                    (OssoABookContactGroupEditor *editor);

void
osso_abook_contact_group_editor_set_contact
                                    (OssoABookContactGroupEditor *editor,
                                     EContact                    *contact);

EContact *
osso_abook_contact_group_editor_get_contact
                                    (OssoABookContactGroupEditor *editor);

G_END_DECLS

#endif /* __OSSO_ABOOK_CONTACT_GROUP_EDITOR_H__ */
