/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_BLOCK_MANAGER_H__
#define __OSSO_ABOOK_BLOCK_MANAGER_H__

#include <libebook/e-book.h>
#include <libebook/e-book-view.h>
#include <gtk/gtkdialog.h>

#include "osso-abook-contact-model.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_BLOCK_MANAGER \
                (osso_abook_block_manager_get_type ())
#define OSSO_ABOOK_BLOCK_MANAGER(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_BLOCK_MANAGER, \
                 OssoABookBlockManager))
#define OSSO_ABOOK_BLOCK_MANAGER_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_BLOCK_MANAGER, \
                 OssoABookBlockManagerClass))
#define OSSO_ABOOK_IS_BLOCK_MANAGER(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_BLOCK_MANAGER))
#define OSSO_ABOOK_IS_BLOCK_MANAGER_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_BLOCK_MANAGER))
#define OSSO_ABOOK_BLOCK_MANAGER_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_BLOCK_MANAGER, \
                 OssoABookBlockManagerClass))

typedef struct _OssoABookBlockManagerPrivate OssoABookBlockManagerPrivate;

typedef struct {
	GtkDialog parent;

        OssoABookBlockManagerPrivate *priv;
} OssoABookBlockManager;

typedef struct {
	GtkDialogClass parent_class;
} OssoABookBlockManagerClass;

GType
osso_abook_block_manager_get_type (void) G_GNUC_CONST;

GtkWidget *
osso_abook_block_manager_new       (OssoABookContactModel *contact_model);

OssoABookContactModel *
osso_abook_block_manager_get_model (OssoABookBlockManager *manager);

G_END_DECLS

#endif /* __OSSO_ABOOK_BLOCK_MANAGER_H__ */
