/*
 * This file is part of libosso-rtcom
 *
 * Copyright (C) 2006 Nokia. All rights reserved.
 *
 * Contact: naba.kumar@nokia.com
 */

#ifndef __RTCOM_PROTOCOL_H__
#define __RTCOM_PROTOCOL_H__

#include <glib.h>
#include <glib-object.h>

#include "rtcom-manager.h"

G_BEGIN_DECLS

#define RTCOM_TYPE_PROTOCOL rtcom_protocol_get_type()

#define RTCOM_PROTOCOL(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  RTCOM_TYPE_PROTOCOL, RtcomProtocol))

#define RTCOM_PROTOCOL_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  RTCOM_TYPE_PROTOCOL, RtcomProtocolClass))

#define RTCOM_IS_PROTOCOL(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  RTCOM_TYPE_PROTOCOL))

#define RTCOM_IS_PROTOCOL_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  RTCOM_TYPE_PROTOCOL))

#define RTCOM_PROTOCOL_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  RTCOM_TYPE_PROTOCOL, RtcomProtocolClass))

GType rtcom_protocol_get_type (void);

typedef struct {
    GObject parent;
    gpointer priv;
} RtcomProtocol;

typedef struct {
    GObjectClass parent_class;
} RtcomProtocolClass;

/* protocols are only unique within the context of a particular manager */
RtcomProtocol *rtcom_protocol_lookup (RtcomManager *id, const gchar *protocol);
void rtcom_protocol_free (RtcomProtocol *id);

GList *rtcom_protocols_list (void);
GList *rtcom_protocols_list_by_manager (RtcomManager *id);
void rtcom_protocols_free_list (GList *list);

RtcomManager *rtcom_protocol_get_manager (RtcomProtocol *id);
const gchar *rtcom_protocol_get_name (RtcomProtocol *id);

enum
{
  RTCOM_PROTOCOL_PARAM_REQUIRED = 1 << 0,
  RTCOM_PROTOCOL_PARAM_REGISTER = 1 << 1
};

/* return type for params */
typedef struct
{
    const gchar *name;
    const gchar *signature;
    guint flags;
} RtcomProtocolParam;

/* Returns list of RtcomProtocolParam. */
GSList *rtcom_protocol_get_params (RtcomProtocol *param);

/* Frees the lists above and all data */
void rtcom_protocol_free_params_list (GSList *list);

void rtcom_protocol_print (RtcomProtocol *protocol);

G_END_DECLS

#endif /* __RTCOM_PROTOCOL_H__ */
