/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_TREE_VIEW_H__
#define __OSSO_ABOOK_TREE_VIEW_H__

#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtkdnd.h>
#include <gtk/gtktreeview.h>
#include <libebook/e-contact.h>

#include "osso-abook-tree-model.h"
#include "osso-abook-filter-model.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_TREE_VIEW \
                (osso_abook_tree_view_get_type ())
#define OSSO_ABOOK_TREE_VIEW(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_TREE_VIEW, \
                 OssoABookTreeView))
#define OSSO_ABOOK_TREE_VIEW_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_TREE_VIEW, \
                 OssoABookTreeViewClass))
#define OSSO_ABOOK_IS_TREE_VIEW(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_TREE_VIEW))
#define OSSO_ABOOK_IS_TREE_VIEW_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_TREE_VIEW))
#define OSSO_ABOOK_TREE_VIEW_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_TREE_VIEW, \
                 OssoABookTreeViewClass))

typedef struct _OssoABookTreeViewPrivate OssoABookTreeViewPrivate;

typedef struct {
	GtkScrolledWindow parent;

        OssoABookTreeViewPrivate *priv;
} OssoABookTreeView;

typedef struct {
	GtkScrolledWindowClass parent_class;

        /* vtable */
        gboolean (* is_row_sensitive) (OssoABookTreeView *view,
                                       GtkTreeModel      *tree_model,
                                       GtkTreeIter       *iter);
} OssoABookTreeViewClass;

GType
osso_abook_tree_view_get_type           (void) G_GNUC_CONST;

GtkTreeModel *
osso_abook_tree_view_get_model          (OssoABookTreeView *view);

OssoABookTreeModel *
osso_abook_tree_view_get_base_model     (OssoABookTreeView *view);

OssoABookFilterModel *
osso_abook_tree_view_get_filter_model   (OssoABookTreeView *view);

GtkTreeView *
osso_abook_tree_view_get_tree_view      (OssoABookTreeView *view);

void
osso_abook_tree_view_select_first       (OssoABookTreeView *view);

void
osso_abook_tree_view_enable_drag_source (OssoABookTreeView *view,
                                         GtkTargetEntry    *targets,
                                         int                n_targets);

G_END_DECLS

#endif /* __OSSO_ABOOK_TREE_VIEW_H__ */
