/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_GROUP_MODEL_H__
#define __OSSO_ABOOK_GROUP_MODEL_H__

#include <gtk/gtkliststore.h>

#include "osso-abook-group.h"

G_BEGIN_DECLS

typedef enum {
        OSSO_ABOOK_GROUP_MODEL_COL_GROUP = 0 /* OssoABookGroup *  */
} OssoABookGroupModelColumn;

#define OSSO_ABOOK_TYPE_GROUP_MODEL \
                (osso_abook_group_model_get_type ())
#define OSSO_ABOOK_GROUP_MODEL(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_MODEL, \
                 OssoABookGroupModel))
#define OSSO_ABOOK_GROUP_MODEL_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_GROUP_MODEL, \
                 OssoABookGroupModelClass))
#define OSSO_ABOOK_IS_GROUP_MODEL(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_MODEL))
#define OSSO_ABOOK_IS_GROUP_MODEL_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_GROUP_MODEL))
#define OSSO_ABOOK_GROUP_MODEL_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_GROUP_MODEL, \
                 OssoABookGroupModelClass))

typedef struct {
	GtkListStore parent;
} OssoABookGroupModel;

typedef struct {
	GtkListStoreClass parent_class;
} OssoABookGroupModelClass;

GType
osso_abook_group_model_get_type     (void) G_GNUC_CONST;

OssoABookGroupModel *
osso_abook_group_model_new          (void);

void
osso_abook_group_model_add_group    (OssoABookGroupModel *model,
                                     OssoABookGroup      *group);

void
osso_abook_group_model_remove_group (OssoABookGroupModel *model,
                                     OssoABookGroup      *group);

gboolean
osso_abook_group_model_get_iter     (OssoABookGroupModel *model,
                                     OssoABookGroup      *group,
                                     GtkTreeIter         *iter);  

G_END_DECLS

#endif /* __OSSO_ABOOK_GROUP_MODEL_H__ */
