/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_CONTACT_SELECTOR_H__
#define __OSSO_ABOOK_CONTACT_SELECTOR_H__

#include "osso-abook-contact-view.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_CONTACT_SELECTOR \
                (osso_abook_contact_selector_get_type ())
#define OSSO_ABOOK_CONTACT_SELECTOR(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_SELECTOR, \
                 OssoABookContactSelector))
#define OSSO_ABOOK_CONTACT_SELECTOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_SELECTOR, \
                 OssoABookContactSelectorClass))
#define OSSO_ABOOK_IS_CONTACT_SELECTOR(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_SELECTOR))
#define OSSO_ABOOK_IS_CONTACT_SELECTOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_SELECTOR))
#define OSSO_ABOOK_CONTACT_SELECTOR_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_SELECTOR, \
                 OssoABookContactSelectorClass))

typedef struct _OssoABookContactSelectorPrivate OssoABookContactSelectorPrivate;

typedef struct {
	OssoABookContactView parent;

        OssoABookContactSelectorPrivate *priv;
} OssoABookContactSelector;

typedef struct {
	OssoABookContactViewClass parent_class;

        void (* extended_selection_changed)
                                   (OssoABookContactSelector *selector,
                                    guint                     n_selected_rows);
} OssoABookContactSelectorClass;

GType
osso_abook_contact_selector_get_type  (void) G_GNUC_CONST;

GtkWidget *
osso_abook_contact_selector_new       (OssoABookContactModel    *model,
                                       OssoABookFilterModel     *filter_model);

GtkWidget *
osso_abook_contact_selector_new_basic (OssoABookContactModel    *model);

GList *
osso_abook_contact_selector_get_extended_selection
                                      (OssoABookContactSelector *selector);

void
osso_abook_contact_selector_select_all
                                      (OssoABookContactSelector *selector);

void
osso_abook_contact_selector_deselect_all
                                      (OssoABookContactSelector *selector);

void
osso_abook_contact_selector_select_contact
                                      (OssoABookContactSelector *selector,
                                       EContact                 *contact);

void
osso_abook_contact_selector_deselect_contact
                                      (OssoABookContactSelector *selector,
                                       EContact                 *contact);

void
osso_abook_contact_selector_set_minimum_selection
                                      (OssoABookContactSelector *selector,
                                       guint                     minimum);

guint
osso_abook_contact_selector_get_minimum_selection
                                      (OssoABookContactSelector *selector);

void
osso_abook_contact_selector_set_maximum_selection
                                      (OssoABookContactSelector *selector,
                                       guint                     maximum);

guint
osso_abook_contact_selector_get_maximum_selection
                                      (OssoABookContactSelector *selector);

void
osso_abook_contact_selector_set_checkbox_selection_only
                            (OssoABookContactSelector *selector,
                             gboolean                  checkbox_selection_only);

gboolean
osso_abook_contact_selector_get_checkbox_selection_only
                            (OssoABookContactSelector *selector);

G_END_DECLS

#endif /* __OSSO_ABOOK_CONTACT_SELECTOR_H__ */
