/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_CONTACT_PRESENCE_H__
#define __OSSO_ABOOK_CONTACT_PRESENCE_H__

#include <libebook/e-book-view.h>

#include "osso-abook-presence.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_CONTACT_PRESENCE \
                (osso_abook_contact_presence_get_type ())
#define OSSO_ABOOK_CONTACT_PRESENCE(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_PRESENCE, \
                 OssoABookContactPresence))
#define OSSO_ABOOK_CONTACT_PRESENCE_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_PRESENCE, \
                 OssoABookContactPresenceClass))
#define OSSO_ABOOK_IS_CONTACT_PRESENCE(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_PRESENCE))
#define OSSO_ABOOK_IS_CONTACT_PRESENCE_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_PRESENCE))
#define OSSO_ABOOK_CONTACT_PRESENCE_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_PRESENCE, \
                 OssoABookContactPresenceClass))

typedef struct _OssoABookContactPresencePrivate OssoABookContactPresencePrivate;

typedef struct {
	OssoABookPresence parent;

        OssoABookContactPresencePrivate *priv;
} OssoABookContactPresence;

typedef struct {
	OssoABookPresenceClass parent_class;
} OssoABookContactPresenceClass;

GType
osso_abook_contact_presence_get_type      (void) G_GNUC_CONST; 

OssoABookContactPresence *
osso_abook_contact_presence_new           (EContact                 *contact);

void
osso_abook_contact_presence_set_contact   (OssoABookContactPresence *presence,
                                           EContact                 *contact);

EContact *
osso_abook_contact_presence_get_contact   (OssoABookContactPresence *presence);

void
osso_abook_contact_presence_set_book_view (OssoABookContactPresence *presence,
                                           EBookView                *book_view);

EBookView *
osso_abook_contact_presence_get_book_view (OssoABookContactPresence *presence);

G_END_DECLS

#endif /* __OSSO_ABOOK_CONTACT_PRESENCE_H__ */
