/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_CONTACT_EDITOR_H__
#define __OSSO_ABOOK_CONTACT_EDITOR_H__

#include <gtk/gtkdialog.h>
#include <libebook/e-book.h>

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_CONTACT_EDITOR \
                (osso_abook_contact_editor_get_type ())
#define OSSO_ABOOK_CONTACT_EDITOR(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_EDITOR, \
                 OssoABookContactEditor))
#define OSSO_ABOOK_CONTACT_EDITOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_EDITOR, \
                 OssoABookContactEditorClass))
#define OSSO_ABOOK_IS_CONTACT_EDITOR(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_EDITOR))
#define OSSO_ABOOK_IS_CONTACT_EDITOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_CONTACT_EDITOR))
#define OSSO_ABOOK_CONTACT_EDITOR_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_CONTACT_EDITOR, \
                 OssoABookContactEditorClass))

typedef struct {
        GtkDialog parent;
} OssoABookContactEditor;

typedef struct {
        GtkDialogClass parent_class;
        void (*added) (OssoABookContactEditor *editor, EBookStatus status, const char* uid);
} OssoABookContactEditorClass;

typedef void (*contact_added_cb) (const char* uid, gpointer user_data);

GType
osso_abook_contact_editor_get_type      (void) G_GNUC_CONST;

GtkWidget *
osso_abook_contact_editor_new           (void);

void
osso_abook_contact_editor_set_book_view (OssoABookContactEditor *editor,
                                         EBookView              *book_view);

EBookView *
osso_abook_contact_editor_get_book_view (OssoABookContactEditor *editor);

void
osso_abook_contact_editor_set_contact   (OssoABookContactEditor *editor,
                                         EContact               *contact);

EContact *
osso_abook_contact_editor_get_contact   (OssoABookContactEditor *editor);

void
osso_abook_contact_editor_set_editable  (OssoABookContactEditor *editor,
                                         gboolean                editable);

gboolean
osso_abook_contact_editor_get_editable  (OssoABookContactEditor *editor);

void
osso_abook_contact_editor_set_new       (OssoABookContactEditor *editor,
                                         gboolean                new);

gboolean
osso_abook_contact_editor_get_new       (OssoABookContactEditor *editor);

void
osso_abook_contact_editor_set_added_cb (OssoABookContactEditor *editor,
                                        contact_added_cb cb, gpointer userdata);

G_END_DECLS

#endif /* __OSSO_ABOOK_CONTACT_EDITOR_H__ */
