/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_ADD_TO_CONTACTS_DIALOG_H__
#define __OSSO_ABOOK_ADD_TO_CONTACTS_DIALOG_H__

#include <gtk/gtkdialog.h>

#include "osso-abook-contact-model.h"
#include "osso-abook-account.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_ADD_TO_CONTACTS_DIALOG \
                (osso_abook_add_to_contacts_dialog_get_type ())
#define OSSO_ABOOK_ADD_TO_CONTACTS_DIALOG(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_ADD_TO_CONTACTS_DIALOG, \
                 OssoABookAddToContactsDialog))
#define OSSO_ABOOK_ADD_TO_CONTACTS_DIALOG_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_ADD_TO_CONTACTS_DIALOG, \
                 OssoABookAddToContactsDialogClass))
#define OSSO_ABOOK_IS_ADD_TO_CONTACTS_DIALOG(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_ADD_TO_CONTACTS_DIALOG))
#define OSSO_ABOOK_IS_ADD_TO_CONTACTS_DIALOG_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_ADD_TO_CONTACTS_DIALOG))
#define OSSO_ABOOK_ADD_TO_CONTACTS_DIALOG_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_ADD_TO_CONTACTS_DIALOG, \
                 OssoABookAddToContactsDialogClass))

typedef struct _OssoABookAddToContactsDialogPrivate
                OssoABookAddToContactsDialogPrivate;

typedef struct {
	GtkDialog parent;

        OssoABookAddToContactsDialogPrivate *priv;
} OssoABookAddToContactsDialog;

typedef struct {
	GtkDialogClass parent_class;
} OssoABookAddToContactsDialogClass;

GType
osso_abook_add_to_contacts_dialog_get_type
                                      (void) G_GNUC_CONST;

GtkWidget *
osso_abook_add_to_contacts_dialog_new (OssoABookContactModel        *model,
                                       OssoABookAccount             *account);

OssoABookContactModel *
osso_abook_add_to_contacts_dialog_get_model
                                      (OssoABookAddToContactsDialog *dialog);

OssoABookAccount *
osso_abook_add_to_contacts_dialog_get_account
                                      (OssoABookAddToContactsDialog *dialog);

G_END_DECLS

#endif /* __OSSO_ABOOK_ADD_TO_CONTACTS_DIALOG_H__ */
