/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_ACCOUNT_VIEW_H__
#define __OSSO_ABOOK_ACCOUNT_VIEW_H__

#include "osso-abook-tree-view.h"
#include "osso-abook-account-model.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_ACCOUNT_VIEW \
                (osso_abook_account_view_get_type ())
#define OSSO_ABOOK_ACCOUNT_VIEW(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_VIEW, \
                 OssoABookAccountView))
#define OSSO_ABOOK_ACCOUNT_VIEW_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT_VIEW, \
                 OssoABookAccountViewClass))
#define OSSO_ABOOK_IS_ACCOUNT_VIEW(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_VIEW))
#define OSSO_ABOOK_IS_ACCOUNT_VIEW_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT_VIEW))
#define OSSO_ABOOK_ACCOUNT_VIEW_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_VIEW, \
                 OssoABookAccountViewClass))

typedef struct {
	OssoABookTreeView parent;
} OssoABookAccountView;

typedef struct {
	OssoABookTreeViewClass parent_class;

        void (* tuple_activated)   (OssoABookAccountView       *view,
                                    OssoABookAccountModelTuple *tuple);

        void (* selection_changed) (OssoABookAccountView       *view,
                                    guint                       n_sel_rows);
} OssoABookAccountViewClass;

GType
osso_abook_account_view_get_type      (void) G_GNUC_CONST;

GtkWidget *
osso_abook_account_view_new           (OssoABookAccountModel *model,
                                       OssoABookFilterModel  *filter_model);

GtkWidget *
osso_abook_account_view_new_basic     (OssoABookAccountModel *model);

GtkWidget *
osso_abook_account_view_new_no_contact_names (OssoABookAccountModel *model,
                                              OssoABookFilterModel  *filter_model);

GList *
osso_abook_account_view_get_selection (OssoABookAccountView  *view);

OssoABookAccountModelTuple *
osso_abook_account_view_get_focus     (OssoABookAccountView  *view);

G_END_DECLS

#endif /* __OSSO_ABOOK_ACCOUNT_VIEW_H__ */
