/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
 /*
  * This file is part of libosso-abook
  *
  * Copyright (C) 2006 Nokia Corporation. All rights reserved.
  *
  * Contact: Onne Gorter <onne.gorter@nokia.com>
  */

#ifndef __OSSO_ABOOK_ACCOUNT_SELECTOR_H__
#define __OSSO_ABOOK_ACCOUNT_SELECTOR_H__

#include "osso-abook-account-view.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_ACCOUNT_SELECTOR \
                (osso_abook_account_selector_get_type ())
#define OSSO_ABOOK_ACCOUNT_SELECTOR(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_SELECTOR, \
                 OssoABookAccountSelector))
#define OSSO_ABOOK_ACCOUNT_SELECTOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT_SELECTOR, \
                 OssoABookAccountSelectorClass))
#define OSSO_ABOOK_IS_ACCOUNT_SELECTOR(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_SELECTOR))
#define OSSO_ABOOK_IS_ACCOUNT_SELECTOR_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT_SELECTOR))
#define OSSO_ABOOK_ACCOUNT_SELECTOR_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_SELECTOR, \
                 OssoABookAccountSelectorClass))

typedef struct _OssoABookAccountSelectorPrivate OssoABookAccountSelectorPrivate;

typedef struct {
	OssoABookAccountView parent;

        OssoABookAccountSelectorPrivate *priv;
} OssoABookAccountSelector;

typedef struct {
	OssoABookAccountViewClass parent_class;

        void (* extended_selection_changed)
                                   (OssoABookAccountSelector *selector,
                                    guint                     n_selected_rows);
} OssoABookAccountSelectorClass;

GType
osso_abook_account_selector_get_type (void) G_GNUC_CONST;

GtkWidget *
osso_abook_account_selector_new      (OssoABookAccountModel      *model,
                                      OssoABookFilterModel       *filter_model);

GtkWidget *
osso_abook_account_selector_new_basic
                                     (OssoABookAccountModel      *model);

GList *
osso_abook_account_selector_get_extended_selection
                                     (OssoABookAccountSelector   *selector);

void
osso_abook_account_selector_deselect_all
                                     (OssoABookAccountSelector   *selector);

void
osso_abook_account_selector_select_tuple
                                     (OssoABookAccountSelector   *selector,
                                      OssoABookAccountModelTuple *tuple);

void
osso_abook_account_selector_deselect_tuple
                                     (OssoABookAccountSelector   *selector,
                                      OssoABookAccountModelTuple *tuple);

void
osso_abook_account_selector_set_minimum_selection
                                     (OssoABookAccountSelector   *selector,
                                      guint                       minimum);

guint
osso_abook_account_selector_get_minimum_selection
                                     (OssoABookAccountSelector   *selector);

void
osso_abook_account_selector_set_maximum_selection
                                     (OssoABookAccountSelector   *selector,
                                      guint                       maximum);

guint
osso_abook_account_selector_get_maximum_selection
                                     (OssoABookAccountSelector   *selector);

void
osso_abook_account_selector_set_checkbox_selection_only
                            (OssoABookAccountSelector *selector,
                             gboolean                  checkbox_selection_only);

gboolean
osso_abook_account_selector_get_checkbox_selection_only
                            (OssoABookAccountSelector *selector);

G_END_DECLS

#endif /* __OSSO_ABOOK_ACCOUNT_SELECTOR_H__ */
