/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 *
 */

#ifndef __OSSO_ABOOK_ACCOUNT_PRESENCE_H__
#define __OSSO_ABOOK_ACCOUNT_PRESENCE_H__

#include "osso-abook-presence.h"
#include "osso-abook-account.h"

G_BEGIN_DECLS

#define OSSO_ABOOK_TYPE_ACCOUNT_PRESENCE \
                (osso_abook_account_presence_get_type ())
#define OSSO_ABOOK_ACCOUNT_PRESENCE(obj) \
                (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_PRESENCE, \
                 OssoABookAccountPresence))
#define OSSO_ABOOK_ACCOUNT_PRESENCE_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_CAST ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT_PRESENCE, \
                 OssoABookAccountPresenceClass))
#define OSSO_ABOOK_IS_ACCOUNT_PRESENCE(obj) \
                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_PRESENCE))
#define OSSO_ABOOK_IS_ACCOUNT_PRESENCE_CLASS(klass) \
                (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                 OSSO_ABOOK_TYPE_ACCOUNT_PRESENCE))
#define OSSO_ABOOK_ACCOUNT_PRESENCE_GET_CLASS(obj) \
                (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                 OSSO_ABOOK_TYPE_ACCOUNT_PRESENCE, \
                 OssoABookAccountPresenceClass))

typedef struct _OssoABookAccountPresencePrivate OssoABookAccountPresencePrivate;

typedef struct {
	OssoABookPresence parent;

        OssoABookAccountPresencePrivate *priv;
} OssoABookAccountPresence;

typedef struct {
	OssoABookPresenceClass parent_class;
} OssoABookAccountPresenceClass;

GType
osso_abook_account_presence_get_type    (void) G_GNUC_CONST;

OssoABookAccountPresence *
osso_abook_account_presence_new         (OssoABookAccount         *account);

OssoABookAccount *
osso_abook_account_presence_get_account (OssoABookAccountPresence *presence);

G_END_DECLS

#endif /* __OSSO_ABOOK_ACCOUNT_PRESENCE_H__ */
