/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/*
 * This file is part of libosso-abook
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 *   
 */

#ifndef _CHAT_VOIP_UTILS_H_
#define _CHAT_VOIP_UTILS_H_

#include "osso-abook-contact.h"
#include <libosso-rtcom/rtcom-account.h>
#include <gtk/gtkwindow.h>

/**
 * go from an remote address and a vcard_field or protocol_scheme to RtcomAccount; 
 * use local address incase it is know
 * 
 * @params
 * remote_address: the remote address we want to chat on
 * local_address: the users address (from a configured account), give NULL if unknown
 * vcard_field: the vcard_field of the connection, give NULL if unknown
 * protocl_scheme: the protocl_scheme to use, give NULL if unknown
 *
 * @returns
 * RtcomAccount: the user account to use in the chat
 */  
RtcomAccount *
chat_voip_utils_account_from_address(const char *remote_address, const char *local_address, const char *vcard_field, const char *protocol_scheme, RtcomAccountFilter filter, GtkWindow *window);

#endif //_CHAT_VOIP_UTILS_H_
