#!/bin/sh

STARTUP_WIZARD=/usr/bin/osso_startup_wizard
CHECK_TIME="/usr/bin/sudo /usr/sbin/chroot /mnt/initfs /usr/bin/retutime -r"
TGT=''
if [ -e /targets/links/scratchbox.config ]; then
	. /targets/links/scratchbox.config
	TGT=$SBOX_TARGET_DIR
fi

ENABLE_FLAG=0

USER=user
GROUP=users
HOME="$TGT/home/$USER"
AF_INIT=/etc/osso-af-init

start_input()
{
	# we need to start VKB for the wizard...
	if [ -f $AF_INIT/keyboard.defs ]; then
		source $AF_INIT/keyboard.defs
 	fi
	source $AF_INIT/keyboard.sh start
	# give VKB some time to start
	sleep 5
	# start clipboard daemon for the wizard
	if [ -f $AF_INIT/clipboard.sh ]; then
		source $AF_INIT/clipboard.sh start
	fi
}

if [ "$ENABLE_FLAG" = "0" ]; then
	if [ "x$DISPLAY" = "x" ]; then
			echo "$0: Error, DISPLAY is not defined!"
			exit 2
	fi
fi

set -e

case "$1" in
start)
	if [ -e $HOME/.suw_first_run ]; then
		echo "Starting Startup Wizard"
		start_input
		if $STARTUP_WIZARD --save-defaults; then
		        rm -f $HOME/.suw_first_run
		fi
	else
		echo "Checking date and time settings"
		echo $CHECK_TIME |sh 
		if [ $? = 1 ]; then
			echo "Showing time and date dialog"
			start_input
			$STARTUP_WIZARD --date-only
		else echo "retutime -r reported \"RTC operating normally\""
		fi
	fi
	;;
stop)
	echo "Stopping Startup Wizard"
	;;
*)      echo "Usage: $0 {start|stop}"
        exit 1
        ;;
esac
