#!/bin/sh
#
# Copyright (C) 2006 Nokia Corporation.
#
DEV=$1
if [ "x$DEV" = "x" ]; then
  DEV=/dev/mmcblk0
fi
PDEV=$2
if [ "x$PDEV" = "x" ]; then
  PDEV="${DEV}p1"
fi

echo "$0: zeroing beginning of the device, to clear partition table"
dd if=/dev/zero of=$DEV bs=512 count=1 > /dev/null

sfdisk -q -D $DEV << EOF
,,6
EOF
if [ $? != 0 ]; then
  echo "$0: could not make the partition"
  exit 1
else
  echo "$0: successfully created the partition"
  exit 0
fi
