#!/bin/sh
#
# Copyright (C) 2005-2006 Nokia Corporation.
#
PDEV=$1  ;# preferred device (partition)
DEV=$2   ;# device possibly containing PDEV as partition

MP=$3    ;# mount point (optional)
if [ "x$MP" = "x" ]; then
  MP=$MMC_MOUNTPOINT
fi

grep "$PDEV " /proc/mounts > /dev/null
if [ $? != 0 ]; then
  PART_EXISTS=1
  # wait until (or verify) the partition info is available
  I=3
  while [ 1 ]; do
    if [ -e $PDEV ]; then
      break
    fi
    I=`expr $I - 1`
    if [ $I -lt 1 ]; then
      PART_EXISTS=0
      break
    fi
    sleep 1
  done

  if [ $PART_EXISTS = 1 ]; then
    echo "$0: partition found"
    exec mmc-mount $PDEV $MP
  else
    echo "$0: partition not found"
    exec mmc-mount $DEV $MP
  fi
else
  echo "$0: $PDEV is already mounted"
  exit 0
fi
