#!/bin/sh

if [ "x$DBUS_SESSION_BUS_ADDRESS" = "x" ]; then
  echo "$0: Warning, DBUS_SESSION_BUS_ADDRESS is not defined"
  TMP=/etc/osso-af-init/af-defines.sh
  echo "$0: sourcing $TMP"
  source $TMP
fi

# update the MMC volume label
TMP=`sudo /usr/sbin/mmc-rename $MMC_DEVICE_FILE ""`
if [ $? = 0 ]; then
  if [ "${TMP}x" = "(no label)x" ]; then
    exec echo -n "" > "/tmp/.mmc-volume-label"
  else
    exec echo -n "$TMP" > "/tmp/.mmc-volume-label"
  fi
else
  echo -n "" > "/tmp/.mmc-volume-label"
  exit 1
fi
