#!/bin/sh

if [ "x$DBUS_SESSION_BUS_ADDRESS" = "x" ]; then
  echo "$0: Warning, DBUS_SESSION_BUS_ADDRESS is not defined"
  TMP=/etc/osso-af-init/af-defines.sh
  echo "$0: sourcing $TMP"
  source $TMP
fi

grep $MMC_MOUNTPOINT /proc/mounts > /dev/null
if [ $? = 1 ]; then
  INC=1
  while [ ! -e $MMC_DEVICE_FILE ]; do
    if [ $INC -gt 10 ]; then
      echo "$0: Error, MMC device '$MMC_DEVICE_FILE' did not appear"
      exit 2
    fi
    sleep 1
    INC=`expr $INC + 1`
  done
  # it doesn't matter if any arguments weren't provided
  exec sudo mmc-mount $MMC_DEVICE_FILE $MMC_MOUNTPOINT
else
  exit 0
fi
