#!/bin/sh
# This file is part of ke-recv
#
# Copyright (C) 2005-2006 Nokia Corporation. All rights reserved.
#
# Contact: Kimmo Hmlinen <kimmo.hamalainen@nokia.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License 
# version 2 as published by the Free Software Foundation. 
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

if [ $# -lt 1 -o $# -gt 2 ]; then
  echo "Usage: $0 <mount point> [<device file>]"
  exit 1
fi

MP=$1
if [ "x$MP" = "x" ]; then
  MP=$MMC_MOUNTPOINT
fi

grep "$MP " /proc/mounts > /dev/null
if [ $? = 0 ]; then
  umount $MP 2> /dev/null
  RC=$?
else
  # it is not mounted
  RC=0
fi

if [ $# = 2 -a $RC = 0 ]; then
  WHOLEDEV=$2
  # try to unmount all partitions belonging to the device
  # FIXME: could do better than just a guess
  for i in 0 `seq 15`; do
    DEV="${WHOLEDEV}p$i"
    if [ -e $DEV ]; then
      MPS=`grep "$DEV " /proc/mounts | awk '{print $2}'`
      if [ $? = 0 ]; then
        for mp in $MPS; do
          umount $mp 2> /dev/null
          RC=$?
          if [ $RC != 0 ]; then
            echo "$0: could not unmount $mp"
            exit $RC 
          fi
        done
      fi
    fi
  done
fi

exit $RC
