#!/bin/sh

# Copyright (C) 2006,2007 Nokia Corporation. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

run_greeting ()
  {
  export DISPLAY=:0.0

  OUR_LOGO=/usr/share/icons/hicolor/scalable/hildon/qgn_indi_nokia_hands.jpg
  OUR_SOUND=/usr/share/sounds/ui-wake_up_tune.wav
  CUSTOM_LOGO=/usr/share/custom/custom.png
  CUSTOM_SOUND=/usr/share/custom/custom.wav

  /usr/bin/osso_startup_greeting
  BACKGROUND_PID=$(pidof osso_startup_greeting)

  if test -f $OUR_LOGO; then
    /usr/bin/osso_startup_greeting $OUR_LOGO
    OUR_LOGO_PID=$(pidof osso_startup_greeting | sed "s/$BACKGROUND_PID//") 
    /usr/bin/play-sound $OUR_SOUND
    kill -9 $OUR_LOGO_PID
  fi

  if test -f $CUSTOM_LOGO; then
    /usr/bin/osso_startup_greeting $CUSTOM_LOGO
    /usr/bin/play-sound $CUSTOM_SOUND
  fi

# Terminate all osso_startup_greeting processes with extreme prejudice
  kill -9 $(pidof osso_startup_greeting)
  }

if test "$1" = "start"; then
  run_greeting &
  sleep 3
elif test "$1" = "fg"; then
  run_greeting
fi
