#!/bin/sh
#
# Copyright (C) 2006 Nokia Corporation.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA

BACKUP=/usr/bin/osso-backup

if [ -f $HOME/.osso-backup/startup-restored-flag ]; then
    exit 0
fi

INTERNAL_PATH=$INTERNAL_MMC_MOUNTPOINT/backups
EXTERNAL_PATH=$MMC_MOUNTPOINT/backups

FILES=$INTERNAL_PATH/*/backup.metadata 
for FILE in $FILES; do
    if [ -f "$FILE" ]; then
	HAVE_BACKUP=true
	break
    fi
done

FILES=$EXTERNAL_PATH/*/backup.metadata 
for FILE in $FILES; do
    if [ -f "$FILE" ]; then
	HAVE_BACKUP=true
	break
    fi
done

if [ "x$HAVE_BACKUP" = "xtrue" ]; then
    $BACKUP -s
fi
