#!/bin/sh
# This file is part of ke-recv
#
# Copyright (C) 2004-2006 Nokia Corporation. All rights reserved.
#
# Contact: Kimmo Hmlinen <kimmo.hamalainen@nokia.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License 
# version 2 as published by the Free Software Foundation. 
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

RC=0

/sbin/lsmod | grep g_file_storage > /dev/null
if [ $? != 0 ]; then
    DIR=/mnt/initfs/lib/modules/`uname -r`
    if [ -f $DIR/g_file_storage.ko ]; then
        /sbin/insmod $DIR/g_file_storage.ko stall=0 luns=2 removable
        RC=$?
    fi
fi

if [ $RC = 0 -a $# -gt 0 ]; then
    GADGETPATH='/sys/devices/platform/musb_hdrc/gadget'
    if [ $# = 2 ]; then
        echo $1 > $GADGETPATH/gadget-lun0/file
        echo $2 > $GADGETPATH/gadget-lun1/file
    else
        STR=`cat $GADGETPATH/gadget-lun0/file`
        if [ "x$STR" = "x" ]; then
            echo $1 > $GADGETPATH/gadget-lun0/file
        else
            echo $1 > $GADGETPATH/gadget-lun1/file
        fi
    fi
fi

exit $RC
